#!/bin/sh

F_product_db_pre_check()
{
    F_debug_log "F_product_db_pre_check"
    DBPartMountPoint=`F_ini_get $PACKAGE_CONFIG Partition DBPartMountPoint`
    DBNewPartMountPoint=`F_ini_get $PACKAGE_CONFIG Partition DBNewPartMountPoint`
    DBPartSize=`F_ini_get $PACKAGE_CONFIG Partition DBPartSize`
    if [ ${DBPartMountPoint} = "" ];then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Config DBPartMountPoint is not set in section Partition"
        return 1
    fi

    local DBPartMountPoint_size=`du -s $DBPartMountPoint|awk -F' ' '{print $1}'`
    F_debug_log "Need $DBPartMountPoint_size to Backup $DBPartMountPoint: avaiable_backup_dst_space: $avaiable_backup_dst_space"
    if [ $avaiable_backup_dst_space -lt $DBPartMountPoint_size ];then 
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Avaiable backup space size is less than the size of $DBPartMountPoint"
        return 1
    fi
    avaiable_backup_dst_space=`expr $avaiable_backup_dst_space - $DBPartMountPoint_size`

    # DDD 2.0 doesn't support 1.0 upgrade path, so database partition should always exist
    #F_debug_log 'Check avaliable space is enough for creating a database partition'
    #F_debug_log "Need $DBPartSize to create database patition: avaiable_backup_dst_space: $avaiable_backup_dst_space"
    #if [ $avaiable_backup_dst_space -lt $DBPartSize ];then
    #    F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Avaiable backup space size is less than the size of $DBNewPartMountPoint"
    #    return 1
    #fi
    #avaiable_backup_dst_space=`expr $avaiable_backup_dst_space - $DBPartSize`

    F_debug_log 'Check postgresql-9.6 is instlled or not'
    rpm -q postgresql96
    flag_upgrade_to_pgsql96=$?
    F_debug_log "postgresql-9.6 install status: $flag_upgrade_to_pgsql96"

    local server_mode="$(cat /opt/TrendMicro/Pixiebob/server_mode)"
    flag_create_LogDataPart=0
    F_debug_log "Server Mode: ${server_mode}"
    if [ ${server_mode} == "ALL" ];then
        F_debug_log 'Check log data partition is created or not. If not, check avaiable space is enough.'
        LogDataPartMountPoint=`F_ini_get $PACKAGE_CONFIG DDD2.0 LogDataPartMountPoint`
        LogDataPartSize=`F_ini_get $PACKAGE_CONFIG DDD2.0 LogDataPartSize`
        LogDataPartName=`F_ini_get $PACKAGE_CONFIG DDD2.0 LogDataPartName`
        F_debug_log "LogDataPartMountPoint: ${LogDataPartMountPoint}, LogDataPartSize: ${LogDataPartSize}, LogDataPartName: ${LogDataPartName}"
        if [ "${LogDataPartMountPoint}" = "" ] || [ "${LogDataPartSize}" = "" ] || [ "${LogDataPartName}" = "" ];then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Config LogDataPartMountPoint/LogDataPartSize/LogDataPartName are not set in section DDD2.0"
            return 1
        fi
        cat /etc/mtab | grep -q "${LogDataPartMountPoint}\b"
        flag_create_LogDataPart=$?
        if [ "${flag_create_LogDataPart}" != "0" ]; then
            F_debug_log "Need $LogDataPartSize to create log data patition: avaiable_backup_dst_space: $avaiable_backup_dst_space"
            if [ ${avaiable_backup_dst_space} -lt ${LogDataPartSize} ];then
                F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Avaiable backup space size is less than the size of ${LogDataPartMountPoint}"
                return 1
            else
                avaiable_backup_dst_space=`expr $avaiable_backup_dst_space - $LogDataPartSize`
            fi
        else
            F_debug_log "Log data partition [${LogDataPartMountPoint}] already exists."
        fi
    else
        F_debug_log "Only Server mode ALL needs the log data partition."
    fi

    return 0
}

# mount_point, size, name
F_create_part_from_local_data_part()
{
    local local_data_partition=`cat /etc/mtab |grep "$backup_dst\b"|awk -F ' ' '{print \$1}'`
    local local_data_partition_size=`df $backup_dst | grep -Ew "$backup_dst" | awk -F' ' '{print \$2}'`
    local new_partition_mountpoint=$1
    local new_partition_size=$2
    local new_partition_name=$3
    local local_data_partition_new_size=`expr $local_data_partition_size - ${new_partition_size}`

    F_debug_log "Create mount point"
    mkdir -p ${new_partition_mountpoint}
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to create mount point ${new_partition_mountpoint}. Stop upgrade."
        return 1
    fi

    F_debug_log "Stop atop and umount $backup_dst"
    systemctl stop atop
    umount -v $backup_dst
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to un-mount $backup_dst to create new partition [${new_partition_mountpoint}]. Stop upgrade."
        return 1
    fi

    F_debug_log "Check filesystem: e2fsck -fy $local_data_partition"
    e2fsck -fy $local_data_partition
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "e2fsck $local_data_partition is failed. Stop upgrade."
        return 1
    fi

    F_debug_log "Resize filesystem: resize2fs $local_data_partition ${local_data_partition_new_size}k"
    resize2fs $local_data_partition ${local_data_partition_new_size}k
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to resize $local_data_partition. Stop upgrade."
        return 1
    fi

    F_debug_log "Reduce LV: lvreduce -f -L -${new_partition_size}k $local_data_partition"
    lvreduce -f -L -${new_partition_size}k $local_data_partition
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to resize LV $local_data_partition. Stop upgrade."
        return 1
    fi

    F_debug_log "Resize filesystem: resize2fs $local_data_partition"
    resize2fs $local_data_partition

    F_debug_log "Create LV: lvcreate -L ${new_partition_size}k --name ${new_partition_name} ${VG_NAME}"
    lvcreate -L ${new_partition_size}k --name ${new_partition_name} ${VG_NAME}
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to create LV $new_partition_name in ${VG_NAME} . Stop upgrade."
        return 1
    fi

    F_debug_log "Make data partition as ext4 format: mkfs.ext4 /dev/mapper/${VG_NAME}-${new_partition_name}"
    mkfs.ext4 /dev/mapper/${VG_NAME}-${new_partition_name}
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to format /dev/mapper/${VG_NAME}-${new_partition_name} as ext4 . Stop upgrade."
        return 1
    fi

    echo "/dev/mapper/${VG_NAME}-${new_partition_name}  ${new_partition_mountpoint}    ext4 defaults 1 2" >> /etc/fstab
    if [ $? -ne 0 ]; then
        F_debug_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed add new partition ${new_partition_mountpoint} in partition table. Stop upgrade."
        return 1
    fi

    F_debug_log "Remount local data partition"
    mount $local_data_partition $backup_dst
    F_debug_log "Start atop"
    systemctl start atop
    F_debug_log "Success to create partition for ${new_partition_name}"

    return 0
}

# mount_point, size, name, flag_remove_mount_point
F_recovery_part_to_local_data_part()
{
    local local_data_partition=`cat /etc/mtab |grep "$backup_dst\b"|awk -F ' ' '{print \$1}'`
    local new_partition_mountpoint=$1
    local new_partition_size=$2
    local new_partition_name=$3

    F_debug_log "Umount ${new_partition_mountpoint}: umount -f ${new_partition_mountpoint}"
    umount -f ${new_partition_mountpoint} >/dev/null 2>&1

    F_debug_log "Remove LV: lvremove -f /dev/mapper/${VG_NAME}-${new_partition_name}"
    lvremove -f /dev/mapper/${VG_NAME}-${new_partition_name} >/dev/null 2>&1

    F_debug_log "Extend LV: lvextend -f -L +${new_partition_size}k $local_data_partition"
    lvextend -f -L +${new_partition_size}k $local_data_partition >/dev/null 2>&1

    F_debug_log "Resize filesystem: resize2fs $local_data_partition"
    resize2fs $local_data_partition >/dev/null 2>&1

    F_debug_log "Remove 'mount ${new_partition_mountpoint}' in fstab: sed -in \"\/dev\/mapper\/${VG_NAME}-${new_partition_name}/d\" /etc/fstab"
    sed -in "\/dev\/mapper\/${VG_NAME}-${new_partition_name}/d" /etc/fstab >/dev/null 2>&1

    F_debug_log "Success to remove partition ${new_partition_mountpoint}."
    F_debug_log "Success to extend partition ${local_data_partition} with size ${new_partition_size}k."

    return 0
}

F_product_db_pre_apply()
{
    F_debug_log "F_product_db_pre_apply"
    F_debug_log "Backup DB data"
    DBPartMountPoint=`F_ini_get $PACKAGE_CONFIG Partition DBPartMountPoint`

    if [ "$flag_upgrade_to_pgsql96" == "1" ];then 
        F_debug_log "Remove conflict rpms for postgresql-9.6"
        /usr/bin/rpm -e PyGreSQL-4.0-9.el7.x86_64
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to remove conflict rpms: PyGreSQL-4.0-9.el7.x86_64. Stop Upgrade."
            return 1
        fi

        F_debug_log "Upgrade postgresql to 9.6"
        /usr/bin/rpm -Uvh --force $UNPACK_DIR/packages/postgresql_rpms/*.rpm
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to upgrade postgresql to v9.6. Stop Upgrade."
            return 1
        fi

        F_debug_log "postgresql: Init db"
        /usr/pgsql-9.6/bin/postgresql96-setup initdb
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to init db. Stop Upgrade."
            return 1
        fi

        F_debug_log "postgresql: check compatible status"
        echo "      su - postgres -c \"/usr/pgsql-9.6/bin/pg_upgrade --old-bindir=/usr/pgsql-9.3/bin/ --new-bindir=/usr/pgsql-9.6/bin/ --old-datadir=$DBPartMountPoint/9.3/data/ --new-datadir=$DBPartMountPoint/9.6/data/ --check\""
        su - postgres -c "/usr/pgsql-9.6/bin/pg_upgrade --old-bindir=/usr/pgsql-9.3/bin/ --new-bindir=/usr/pgsql-9.6/bin/ --old-datadir=$DBPartMountPoint/9.3/data/ --new-datadir=$DBPartMountPoint/9.6/data/ --check" | grep -q '\*Clusters are compatible\*'
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to check db compatible status. Stop Upgrade."
            return 1
        fi

        F_debug_log "postgresql: upgrade cluster data"
        echo "      su - postgres -c \"/usr/pgsql-9.6/bin/pg_upgrade --old-bindir=/usr/pgsql-9.3/bin/ --new-bindir=/usr/pgsql-9.6/bin/ --old-datadir=$DBPartMountPoint/9.3/data/ --new-datadir=$DBPartMountPoint/9.6/data/\""
        su - postgres -c "/usr/pgsql-9.6/bin/pg_upgrade --old-bindir=/usr/pgsql-9.3/bin/ --new-bindir=/usr/pgsql-9.6/bin/ --old-datadir=$DBPartMountPoint/9.3/data/ --new-datadir=$DBPartMountPoint/9.6/data/"
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to upgrade db data to postgresql-9.6. Stop Upgrade."
            return 1
        fi

        F_debug_log "postgresql: enable serivce"
        systemctl enable postgresql-9.6.service
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to enable postgresql-9.6.service. Stop Upgrade."
            return 1
        fi

    fi


    F_debug_log "Backup DB data"
    [ -e $DDDDBBackupFile ] && /usr/bin/rm $DDDDBBackupFile
    /usr/bin/tar zcf $DDDDBBackupFile $DBPartMountPoint 2>&1
    TAR_RV=$?
    #cp -af $DBPartMountPoint $backup_dst/backup/db/
    if [ $TAR_RV -eq 1 ]; then
        F_debug_log "$FUNCNAME" "`expr $LINENO - 1`" "Source file being changed while archived, should have no impact."
    elif [ $TAR_RV -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to backup $DBPartMountPoint. Stop Upgrade ($TAR_RV)"
        return 1
    fi

    if [ "${flag_create_LogDataPart}" != "0" ];then 
        F_debug_log "(For 2.0) Add a partition for log data"
        F_create_part_from_local_data_part "${LogDataPartMountPoint}" "${LogDataPartSize}" "${LogDataPartName}" || {
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Fail to create log data partition."
            return 1
        } && {
            F_prompt_log "Create a new partition for log data."
        }
    fi

    F_debug_log "(For 1.0) Add a partition for database"
    DBPart=`F_ini_get $PACKAGE_CONFIG Partition DBPart`
    db_part=$(cat /etc/mtab |grep "${DBPart}\b")
    if [ "${db_part}" != "" ]; then
        F_debug_log "DB partition [${db_part}] already exists, skip."
        return 0
    fi

    cat /etc/mtab |grep -q "$backup_dst\b"
    if [ $? -eq 0 ]; then
        local local_data_partition=`cat /etc/mtab |grep "$backup_dst\b"|awk -F ' ' '{print \$1}'`
        local local_data_partition_size=`df $backup_dst | grep -Ew "$backup_dst" | awk -F' ' '{print \$2}'`
        local local_data_partition_new_size=`expr $local_data_partition_size - $DBPartSize`

        F_debug_log "Stop atop and umount $backup_dst"
        systemctl stop atop
        umount -v $backup_dst
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to un-mount $backup_dst to create DB partition. Stop upgrade."
            return 1
        fi

        F_debug_log "Check filesystem: e2fsck -fy $local_data_partition"
        e2fsck -fy $local_data_partition
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "e2fsck $local_data_partition is failed. Stop upgrade."
            return 1
        fi

        F_debug_log "Resize filesystem: resize2fs $local_data_partition ${local_data_partition_new_size}k"
        resize2fs $local_data_partition ${local_data_partition_new_size}k
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to resize $local_data_partition. Stop upgrade."
            return 1
        fi

        F_debug_log "Reduce LV: lvreduce -f -L -${DBPartSize}k $local_data_partition"
        lvreduce -f -L -${DBPartSize}k $local_data_partition
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to resize LV $local_data_partition. Stop upgrade."
            return 1
        fi

        F_debug_log "Resize filesystem: resize2fs $local_data_partition"
        resize2fs $local_data_partition

        F_debug_log "Create LV: lvcreate -L ${DBPartSize}k --name ${DBPart} ${VG_NAME}"
        lvcreate -L ${DBPartSize}k --name ${DBPart} ${VG_NAME}
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to create LV $DBPart in ${VG_NAME} . Stop upgrade."
            return 1
        fi

        F_debug_log "Make data partition as ext4 format: mkfs.ext4 /dev/mapper/${VG_NAME}-${DBPart}"
        mkfs.ext4 /dev/mapper/${VG_NAME}-${DBPart}
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to format /dev/mapper/${VG_NAME}-${DBPart} as ext4 . Stop upgrade."
            return 1
        fi

        echo "/dev/mapper/${VG_NAME}-${DBPart}  $DBNewPartMountPoint    ext4 defaults 1 2" >> /etc/fstab
        if [ $? -ne 0 ]; then
            F_debug_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed add database new partition in partition table. Stop upgrade."
        fi

        F_debug_log "Remount local data partition"
        mount $local_data_partition $backup_dst
        F_debug_log "Start atop"
        systemctl start atop
        F_debug_log "Success to create partition for database"
    else
        F_debug_log "No local data partition to split. Stop upgrade"
        return 1
    fi

    return 0
}

F_product_db_post_apply()
{
    F_debug_log "F_product_db_post_apply"

    F_debug_log "Mount database partition before restore data, DB mount point:'${DBNewPartMountPoint}'"
    mount -t ext4 -o rw /dev/mapper/${VG_NAME}-${DBPart} ${DBNewPartMountPoint}

    F_debug_log "Untar backuped DB, DB mount point:'${DBNewPartMountPoint}'"
    /usr/bin/tar zxf $DDDDBBackupFile -C /
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to restore $DBPartMountPoint."
    fi

    if [ "$flag_upgrade_to_pgsql96" == "1" ];then 
        F_debug_log "Replace postgresql-9.6 configuration files, DB mount point:'${DBNewPartMountPoint}'"
        /usr/bin/cp -f ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/init/config/pgsql/pg_hba.conf.sample ${DBNewPartMountPoint}/9.6/data/pg_hba.conf 2>&1
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to update pg_hba.conf."
            return 1
        fi

        /usr/bin/cp -f ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/init/config/pgsql/postgresql.conf.sample ${DBNewPartMountPoint}/9.6/data/postgresql.conf 2>&1
        if [ $? -ne 0 ]; then
            F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to update postgresql.conf."
            return 1
        fi

        F_debug_log "Remove postgresql-9.3 related data"
        /usr/bin/rpm -qa | grep postgresql93 | /usr/bin/xargs /usr/bin/rpm --root $SYS_ROOT_DIR -e
        /usr/bin/rm -rf ${DBNewPartMountPoint}/9.3
    fi

    return 0
}

F_product_db_pre_apply_recovery()
{
    if [ "${flag_create_LogDataPart}" != "0" ]; then
        F_recovery_part_to_local_data_part "${LogDataPartMountPoint}" "${LogDataPartSize}" "${LogDataPartName}"
    fi
    F_debug_log "Remount all partition"
    mount -a

    F_debug_log "Remove DB backup file: $DDDDBBackupFile"
    if [ -e $DDDDBBackupFile ]; then
        /usr/bin/tar zxf $DDDDBBackupFile -C /
        /usr/bin/rm $DDDDBBackupFile
    fi
    if [ "$flag_upgrade_to_pgsql96" == "1" ];then 
        F_debug_log "remove postgresql-9.6 and its data folder"
        /usr/bin/rpm -qa |/usr/bin/grep postgresql96 | /usr/bin/xargs /usr/bin/rpm -e
        /usr/bin/rm -rf $DBPartMountPoint/9.6
        F_debug_log "re-install postgresql-9.3 dependency rpms"
        /usr/bin/rpm -Uvh --oldpackage $UNPACK_DIR/packages/downgrade_rpms/*.rpm
    fi

    return 0
}

F_product_db_post_apply_recovery()
{
    F_debug_log "Restore DB recovery"

    return 0
}

